parcel_services.controllers.module('delete-modal',
	['xhr', `${gx.source}/libs/info_messages`,],
	() => {
		return {
			vue: true,
			name: 'gx-delete-modal',
			template: '#delete-modal',
			parent: 'gx-parcel-services-overview',
			props: ['details'],
			data: () => ({
				lang: {
					title: jse.core.lang.translate('delete_modal_title', 'parcel_services'),
					close: jse.core.lang.translate('cancel', 'buttons'),
					confirm: jse.core.lang.translate('delete', 'buttons'),
					labels: {
						text: jse.core.lang.translate('delete_modal_text', 'parcel_services'),
						name: jse.core.lang.translate('label_name', 'parcel_services'),
					},
				},
			}),
			methods: {
				confirm() {
					jse.libs.xhr.delete({
						url: './api/parcel-services/' + this.details.id,
					}).done(response => {
						this.$emit('reload-overview');
					}).fail((response) => {
						console.error('Could not delete parcel service.', response);
						jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_delete_parcel_service', 'parcel_services'));
					});
					$('.delete-modal.modal').modal('hide');
				},
				openModal(deleteDetails) {
					this.details = deleteDetails;
					$('.delete-modal.modal').modal('show');
				},
			},
			created() {
			},
			init: done => done()
		}
	});